package game;

import javax.sound.sampled.Clip;
import javax.swing.JOptionPane;

public class BackgroundMusic implements Runnable {
	
	private Clip bgm1;
//	private Thread thread;
	private boolean threadShouldRun;
	private String name;
	
	public static BackgroundMusic getDefault() {
		
		BackgroundMusic returnValue = new BackgroundMusic("/sounds/rainbow factory original instrumental.wav");
		
		return returnValue;
	}

	@Override
	public void run() {
		
		while(threadShouldRun && bgm1 != null) {
			
			if(bgm1.getFramePosition() + 10 >= bgm1.getFrameLength() 
					|| (!bgm1.isRunning() && threadShouldRun)) {
				bgm1.setFramePosition(0);
				if(!bgm1.isRunning())
					bgm1.start();
			}
			
			//System.out.println("BGM frame position: " + bgm1.getFramePosition() + ", length: " + bgm1.getFrameLength());
			
			Thread.yield();
			
		}
		
//		thread = null;
//		System.out.println("thread ended!!");
		
	}
	
	public void checkToSeeIfShouldLoop() {
		if(threadShouldRun && bgm1 != null) {
			
			if(bgm1.getFramePosition() + 10 >= bgm1.getFrameLength() 
					|| (!bgm1.isRunning() && threadShouldRun)) {
				bgm1.setFramePosition(0);
				if(!bgm1.isRunning())
					bgm1.start();
			}
			
			
		}
	}
	
	
	public void start() {
		
		threadShouldRun = true;
		
		if(bgm1 == null)
			return;
		
//		thread = new Thread(this);
		bgm1.start();
//		try {
//			if(!thread.isAlive() && !thread.isInterrupted())
//				thread.start();
//		} catch(IllegalThreadStateException e) {
//			e.printStackTrace();
//			
//		}
	}
	
	public void startFromBeginning() {
		
		threadShouldRun = true;
//		thread = new Thread(this);
		if(bgm1 == null)
			return;
		
		bgm1.setFramePosition(0);
		bgm1.start();
//		try {
//			if(!thread.isAlive() && !thread.isInterrupted())
//				thread.start();
//		} catch(IllegalThreadStateException e) {
//			e.printStackTrace();
//			
//		}
	}
	
	public void startIfNotAlreadyStarted() {
		
		if(!threadShouldRun)
			start();
		
	}
	
	public void pause() {
		
		threadShouldRun = false;
		
		if(bgm1 == null)
			return;
		
		bgm1.stop();
		
//		thread = null;
		
	}
	
	
	public BackgroundMusic(String theBGM) {
		
		AudioManager am = new AudioManager();
		bgm1 = am.loadGivenClipViaURL(theBGM);
		threadShouldRun = false;
		name = theBGM;
		
	}
	
	
	public boolean isRunning() {
		return threadShouldRun;
	}
	
	public BackgroundMusic(String theBGM, boolean dummy) {
		
		AudioManager am = new AudioManager();
		try {
			bgm1 = am.loadGivenClip(theBGM);
		} catch(Exception e) {
			JOptionPane.showMessageDialog(null, "<html>Error while trying to load the background music file " + theBGM + ".  <br>Stack trace (stack traces are helpful for programmers trying to figure out what happened):<br>" + PonyPanel.formatStackTrace(e) + "</html>","Error loading music",JOptionPane.ERROR_MESSAGE);
		}
		threadShouldRun = false;
		
	}
	
	public void dispose() {
		
		if(bgm1 == null)
			return;
		
		bgm1.stop();
		bgm1.close();
	}
	
	public boolean equals(BackgroundMusic other) {
		if(other == null)
			return false;
		if(other.name == null && this.name != null)
			return false;
		if(other.name == null && this.name == null)
			return true;
		return other.name.equals(this.name);
	}
	
}
